/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lhadecompressor;

import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.lhadecompressor.LhDecoder;
import net.sourceforge.lhadecompressor.LhaException;

public class Lh3Decoder
extends LhDecoder {
    private static final int BUFBITS = 16;
    private static final int NP = 128;
    private static final int CBIT = 9;
    private static final int CODE_TABLE_SIZE = 4096;
    private static final int N1 = 286;
    private static final int EXTRA_BITS = 8;
    private static final int LENGTH_FIELD = 4;
    private static final int[] FIXED = new int[]{2, 1, 1, 3, 6, 13, 31, 78, 0};
    private int[] positionCode = new int[128];
    private int[] codeLength = new int[510];
    private int[] codeTable = new int[4096];
    private int np = 128;
    private int blockSize = 0;

    public Lh3Decoder(InputStream in, long originalSize) {
        super(in, originalSize, 13, 253);
    }

    private void readyMade() {
        int index = 0;
        int j = FIXED[index++];
        int weight = 1 << 16 - j;
        int code = 0;
        for (int i = 0; i < this.np; ++i) {
            while (FIXED[index] == i) {
                ++j;
                ++index;
                weight >>>= 1;
            }
            this.positionLength[i] = j;
            this.positionCode[i] = code;
            code += weight;
        }
    }

    private void readTreeCode() throws IOException {
        int i = 0;
        while (i < 286) {
            int j;
            this.codeLength[i] = this.getBits(1) != 0 ? this.getBits(4) + 1 : 0;
            if (++i != 3 || this.codeLength[0] != 1 || this.codeLength[1] != 1 || this.codeLength[2] != 1) continue;
            int c = this.getBits(9);
            for (j = 0; j < 286; ++j) {
                this.codeLength[j] = 0;
            }
            for (j = 0; j < 4096; ++j) {
                this.codeTable[j] = c;
            }
            return;
        }
        this.makeTable(286, this.codeLength, 12, this.codeTable);
    }

    private void readTreePosition() throws IOException {
        int i = 0;
        while (i < 128) {
            int j;
            this.positionLength[i] = this.getBits(4);
            if (++i != 3 || this.positionLength[0] != 1 || this.positionLength[1] != 1 || this.positionLength[2] != 1) continue;
            int c = this.getBits(7);
            for (j = 0; j < 128; ++j) {
                this.positionLength[j] = 0;
            }
            for (j = 0; j < 256; ++j) {
                this.positionTable[j] = c;
            }
            return;
        }
    }

    @Override
    protected void initRead() throws LhaException, IOException {
        this.fillBitBuffer(16);
    }

    @Override
    protected int decodeCode() throws IOException {
        if (this.blockSize == 0) {
            this.blockSize = this.getBits(16);
            this.readTreeCode();
            if (this.getBits(1) != 0) {
                this.readTreePosition();
            } else {
                this.readyMade();
            }
            this.makeTable(128, this.positionLength, 8, this.positionTable);
        }
        --this.blockSize;
        int j = this.codeTable[this.bitBuffer >>> 4];
        if (j < 286) {
            this.fillBitBuffer(this.codeLength[j]);
        } else {
            this.fillBitBuffer(12);
            int b = this.bitBuffer;
            do {
                j = (b & 0x8000) != 0 ? this.treeRight[j] : this.treeLeft[j];
                b <<= 1;
            } while (j >= 286);
            this.fillBitBuffer(this.codeLength[j] - 12);
        }
        if (j == 285) {
            j += this.getBits(8);
        }
        return j;
    }

    @Override
    protected int decodePosition() throws IOException {
        int j = this.positionTable[this.bitBuffer >>> 8];
        if (j < this.np) {
            this.fillBitBuffer(this.positionLength[j]);
        } else {
            this.fillBitBuffer(8);
            int b = this.bitBuffer;
            do {
                j = (b & 0x80) != 0 ? this.treeRight[j] : this.treeLeft[j];
                b <<= 1;
            } while (j >= this.np);
            this.fillBitBuffer(this.positionLength[j] - 8);
        }
        return (j << 6) + this.getBits(6);
    }
}

